document.querySelectorAll('.btn-accent').forEach(btn => {
    btn.addEventListener('click', e => {
      document.querySelectorAll('.trainer-card').forEach(c => c.classList.remove('selected'));
      const card = e.target.closest('.trainer-card');
      card.classList.add('selected');
    });
  });



  document.addEventListener("DOMContentLoaded", () => {
    const cards = document.querySelectorAll(".trainer-card");
  
    cards.forEach(card => {
      const overlay = card.querySelector(".card-overlay");

      card.addEventListener("click", (e) => {
        if (card.classList.contains("selected")) {
          card.classList.remove("selected");
          if (overlay) overlay.setAttribute("aria-hidden", "true");
          cards.forEach(c => c.classList.remove("dimmed"));
          cards.forEach(c => {
            const ov = c.querySelector(".card-overlay");
            if (ov) ov.setAttribute("aria-hidden", "true");
          });
        } 
        else {
          cards.forEach(c => {
            c.classList.remove("selected");
            c.classList.add("dimmed");
            const ov = c.querySelector(".card-overlay");
            if (ov) {
              ov.setAttribute("aria-hidden", "true");
            }
          });
  
          card.classList.add("selected");
          card.classList.remove("dimmed");
          if (overlay) {
            overlay.setAttribute("aria-hidden", "true");
          }
        }
      });

      card.addEventListener("keydown", (e) => {
        if (e.key === "Enter" || e.key === " ") {
          e.preventDefault();
          card.click();
        }
      });

      if (overlay && !card.classList.contains("selected")) {
        overlay.setAttribute("aria-hidden", "true");
      }
    });
  });
  