/*رفرش صفحه*/
window.addEventListener('load', () => {
    const inputs = document.querySelectorAll('input');
    inputs.forEach(input => input.value = '');
    localStorage.clear();
    sessionStorage.clear();
  });


function setfocus(parms) {
    if (parms == 'weight') {
        document.getElementById('image-body').src = "img/manweight.png";
    }
    if (parms == 'gardan') {
        document.getElementById('image-body').src = "img/mangardan.png";
    }
    if (parms == 'sine') {
        document.getElementById('image-body').src = "img/mansine.png";
    }
    if (parms == 'saaed') {
        document.getElementById('image-body').src = "img/mansaaed.png";
    }
    if (parms == 'shekam') {
        document.getElementById('image-body').src = "img/manshekam.png";
    }
    if (parms == 'muchdast') {
        document.getElementById('image-body').src = "img/manmuchdast.png";
    }
    if (parms == 'sughpa') {
        document.getElementById('image-body').src = "img/mansugh.png";
    }
    if (parms == 'height') {
        document.getElementById('image-body').src = "img/manheight.png";
    }
    if (parms == 'shone') {
        document.getElementById('image-body').src = "img/manshone.png";
    }
    if (parms == 'bazo') {
        document.getElementById('image-body').src = "img/manbazo.png";
    }
    if (parms == 'kamar') {
        document.getElementById('image-body').src = "img/mankamar.png";
    }
    if (parms == 'basan') {
        document.getElementById('image-body').src = "img/manbasan.png";
    }
    if (parms == 'run') {
        document.getElementById('image-body').src = "img/manrun.png";
    }
    if (parms == 'muchpa') {
        document.getElementById('image-body').src = "img/manmuch.png";
    }
}

/*----error fild----*/
const rules = {
    "دور شانه": 50,
    "دور سینه": 51,
    "دور شکم": 51,
    "ساعد": 11,
    "دور ران": 20,
    "مچ دست": 11,
    "دور کمر": 51,
    "دور گردن": 21,
    "بازو": 16,
    "دور باسن": 61,
    "مچ پا": 16,
    "ساق پا": 16,
    "وزن": 0,
    "قد": 0
  };
let errorContainer = document.createElement("div");
errorContainer.id = "form-errors";
errorContainer.style.display = "flex";
errorContainer.style.flexDirection = "column";
errorContainer.style.alignItems = "right";
errorContainer.style.gap = "10px";
const alertBox = document.querySelector(".alert-important");
alertBox.insertAdjacentElement("afterend", errorContainer);

const parseNumber = (val) => {
  if (!val && val !== 0) return NaN;
  const persianDigits = "۰۱۲۳۴۵۶۷۸۹";
  const arabicDigits = "٠١٢٣٤٥٦٧٨٩";
  let s = String(val).trim();
  for (let i = 0; i < 10; i++) {
    s = s.split(persianDigits[i]).join(i).split(arabicDigits[i]).join(i);
  }
  s = s.replace(/,/g, ".").replace(/[^\d.\-]/g, "");
  return parseFloat(s);
};

const validateInput = (input) => {
  const placeholder = input.getAttribute("placeholder");
  const min = rules[placeholder];
  if (min === undefined) return;

  let value = parseNumber(input.value);

  if (!isNaN(value) && value <= min) {
    input.classList.add("invalid-field");
    if (!input._errorDiv) {
      const div = document.createElement("div");
      div.className = "form-error-box"; 
      div.textContent = `مقدار ${placeholder} باید بیشتر از ${min} باشد`;
      errorContainer.appendChild(div);
      setTimeout(() => div.classList.add("show"), 10);

      input._errorDiv = div;
    } else {
      input._errorDiv.textContent = `مقدار ${placeholder} باید بیشتر از ${min} باشد`;
    }
  } else {
    if (input._errorDiv) {
      errorContainer.removeChild(input._errorDiv);
      input._errorDiv = null;
    }
    input.classList.remove("invalid-field");
  }
};
const inputs = document.querySelectorAll(".adamak-input .form-control");
inputs.forEach((input) => {
  input.addEventListener("input", () => validateInput(input));
});
  

  /* ============ Body Metrics Dynamic (circular progress) ============ */
(() => {
    // helper: parse Persian & Arabic numbers
    function parseNum(v) {
      if (v === null || v === undefined) return NaN;
      const pers = "۰۱۲۳۴۵۶۷۸۹", arab = "٠١٢٣٤٥٦٧٨٩";
      let s = String(v).trim();
      for (let i = 0; i < 10; i++) {
        s = s.split(pers[i]).join(i).split(arab[i]).join(i);
      }
      s = s.replace(/,/g, '.').replace(/[^\d.\-]/g, '');
      const n = parseFloat(s);
      return isNaN(n) ? NaN : n;
    }
  
    // get inputs by placeholder names (as in your HTML)
    const fields = {
      sine: document.querySelector('input[placeholder="دور سینه"]'),
      shone: document.querySelector('input[placeholder="دور شانه"]'),
      bazo: document.querySelector('input[placeholder="بازو"]'),
      run: document.querySelector('input[placeholder="دور ران"]'),
      sughpa: document.querySelector('input[placeholder="ساق پا"]'),
      shekam: document.querySelector('input[placeholder="دور شکم"]'),
      basan: document.querySelector('input[placeholder="دور باسن"]'),
      gardan: document.querySelector('input[placeholder="گردن"]'),
      weight: document.querySelector('input[placeholder="وزن"]'),
      height: document.querySelector('input[placeholder="قد"]')
    };
  
    // select metric DOMs
    const metricCards = Array.from(document.querySelectorAll('.metric-card'));
    const metrics = {
      muscle: metricCards.find(c => c.dataset.key === 'muscle'),
      bodyfat: metricCards.find(c => c.dataset.key === 'bodyfat'),
      visceral: metricCards.find(c => c.dataset.key === 'visceral')
    };
  
    // utility to animate number
    function animateNumber(el, start, end, duration = 800, unit = '%') {
      const numEl = el.querySelector('.num');
      const startTime = performance.now();
      function step(now) {
        const t = Math.min(1, (now - startTime) / duration);
        const val = Math.round(start + (end - start) * easeOutCubic(t));
        numEl.textContent = val;
        if (t < 1) requestAnimationFrame(step);
        else {
          // append unit handled by CSS small .unit element
        }
      }
      requestAnimationFrame(step);
    }
    function easeOutCubic(t) { return (--t)*t*t + 1; }
  
    // animate ring: stroke-dashoffset based on pct
    function setRingProgress(card, pct) {
      const svg = card.querySelector('.ring');
      const fg = svg.querySelector('.ring-fg');
      const circumference = 2 * Math.PI * 48; // r=48
      const offset = circumference * (1 - Math.max(0, Math.min(1, pct / 100)));
      fg.style.transition = 'stroke-dashoffset 900ms cubic-bezier(.2,.9,.25,1)';
      fg.style.strokeDashoffset = offset;
    }
  
    // compute the three metrics (simple, sensible heuristics)
    function computeMetrics() {
      const S = parseNum(fields.sine?.value);
      const SH = parseNum(fields.shone?.value);
      const B = parseNum(fields.bazo?.value);
      const R = parseNum(fields.run?.value);
      const CA = parseNum(fields.sughpa?.value);
      const W = parseNum(fields.shekam?.value);
      const H = parseNum(fields.basan?.value);
      const G = parseNum(fields.gardan?.value);
      const weight = parseNum(fields.weight?.value);
      const height = parseNum(fields.height?.value);
  
      // Muscle Volume (0-100) — ترکیب دور سینه، بازو، ران، ساق
      // نرمالایز با یک مقدار مرجع تقریبی (مثلاً 230) — نتیجه بین 0 تا 100
      const muscleRaw = ( (isFinite(S)?S:0)*0.45 + (isFinite(B)?B:0)*0.2 + (isFinite(R)?R:0)*0.23 + (isFinite(CA)?CA:0)*0.12 );
      const musclePct = Math.round( Math.max(0, Math.min(100, (muscleRaw / 230) * 100)) );
  
      // Body Fat % (تخمینی) — با توجه به نسبت کمر به قد یا کمر به باسن
      let bodyFat = 0;
      if (isFinite(W) && isFinite(height) && height > 0) {
        const ratio = W / height; // مثال: 90/175 = 0.514 => به درصد تبدیل
        bodyFat = Math.round(Math.max(3, Math.min(40, ratio * 100 * 0.9)));
      } else if (isFinite(W) && isFinite(S)) {
        // fallback: کمر نسبت به سینه
        bodyFat = Math.round(Math.max(3, Math.min(40, ((W / (S||1)) * 15))));
      } else {
        bodyFat = 15; // default neutral
      }
  
      // Visceral Fat Index (واحد تقریبی) — نسبت کمر به باسن * مقیاس
      let visceral = 0;
      if (isFinite(W) && isFinite(H) && H > 0) {
        visceral = Math.round(Math.max(1, Math.min(25, (W / H) * 12)));
      } else if (isFinite(W) && isFinite(G)) {
        visceral = Math.round(Math.max(1, Math.min(25, (W / (G||1)) * 6)));
      } else {
        visceral = 8; // neutral
      }
  
      return {
        muscle: musclePct,
        bodyfat: bodyFat,
        visceral: visceral
      };
    }
  
    // update UI
    function updateUI(animate = true) {
      const vals = computeMetrics();
  
      // MUSCLE
      const mCard = metrics.muscle;
      const currentMuscle = parseInt(mCard.querySelector('.num').textContent || 0, 10);
      if (animate) animateNumber(mCard, currentMuscle, vals.muscle, 700);
      else mCard.querySelector('.num').textContent = vals.muscle;
      setRingProgress(mCard, vals.muscle);
  
      // BODYFAT
      const bCard = metrics.bodyfat;
      const currentBF = parseInt(bCard.querySelector('.num').textContent || 0, 10);
      if (animate) animateNumber(bCard, currentBF, vals.bodyfat, 700);
      else bCard.querySelector('.num').textContent = vals.bodyfat;
      setRingProgress(bCard, Math.max(2, Math.min(100, (40 - vals.bodyfat) * 2.5))); // lower fat -> fuller green-ish
  
      // VISCERAL
      const vCard = metrics.visceral;
      const currentV = parseInt(vCard.querySelector('.num').textContent || 0, 10);
      if (animate) animateNumber(vCard, currentV, vals.visceral, 700);
      else vCard.querySelector('.num').textContent = vals.visceral;
      setRingProgress(vCard, Math.round((vals.visceral / 25) * 100));
    }
  
    document.addEventListener('DOMContentLoaded', () => {
      document.querySelectorAll('.ring-fg').forEach(el => {
        el.style.strokeDasharray = (2 * Math.PI * 48);
        el.style.strokeDashoffset = (2 * Math.PI * 48);
      });
      updateUI(false);
    });
    Object.values(fields).forEach(f => {
      if (!f) return;
      f.addEventListener('input', () => updateUI(true));
      f.addEventListener('change', () => updateUI(true));
    });
  
  })();
  