function previewImage(input) {
    const file = input.files[0];
    if (!file) return;
  
    const reader = new FileReader();
    reader.onload = function (e) {
      const card = input.closest(".upload-card");
      const img = card.querySelector(".preview-img");
      const removeBtn = card.querySelector(".btn-remove");
      const placeholder = card.querySelector(".upload-placeholder");
  
      img.src = e.target.result;
      img.classList.remove("d-none");
      removeBtn.classList.remove("d-none");
      placeholder.classList.add("d-none");
    };
    reader.readAsDataURL(file);
  }
  
  function removeImage(btn) {
    const card = btn.closest(".upload-card");
    const input = card.querySelector(".upload-input");
    const img = card.querySelector(".preview-img");
    const placeholder = card.querySelector(".upload-placeholder");
  
    input.value = "";
    img.src = "";
    img.classList.add("d-none");
    btn.classList.add("d-none");
    placeholder.classList.remove("d-none");
  }


  /*--Other-images--*/
function previewImage(input) {
  const file = input.files[0];
  if (!file) return;

  const reader = new FileReader();
  const cardBody = input.closest('.card-body');
  const img = cardBody.querySelector('.preview-img');
  const placeholder = cardBody.querySelector('.upload-placeholder');
  const removeBtn = cardBody.querySelector('.btn-remove');

  reader.onload = (e) => {
    img.src = e.target.result;
    img.classList.remove('d-none');
    placeholder.classList.add('d-none');
    removeBtn.classList.remove('d-none');
  };
  reader.readAsDataURL(file);
}

function removeImage(button) {
  const cardBody = button.closest('.card-body');
  const input = cardBody.querySelector('.upload-input');
  const img = cardBody.querySelector('.preview-img');
  const placeholder = cardBody.querySelector('.upload-placeholder');

  input.value = "";
  img.src = "";
  img.classList.add('d-none');
  placeholder.classList.remove('d-none');
  button.classList.add('d-none');
}

function previewExtraImage(input) {
  const file = input.files[0];
  if (!file) return;

  const reader = new FileReader();
  reader.onload = (e) => {
    const container = document.getElementById('extra-images');
    const imgWrapper = document.createElement('div');
    imgWrapper.className = 'position-relative';

    const img = document.createElement('img');
    img.src = e.target.result;
    img.className = 'extra-img rounded shadow-sm';

    const removeBtn = document.createElement('button');
    removeBtn.className = 'btn-remove-small';
    removeBtn.innerHTML = '<i class="bi bi-x-lg"></i>';
    removeBtn.onclick = () => imgWrapper.remove();

    imgWrapper.appendChild(img);
    imgWrapper.appendChild(removeBtn);
    container.appendChild(imgWrapper);
  };

  reader.readAsDataURL(file);

  // ساخت input جدید برای آپلودهای بعدی
  const newInput = document.createElement('input');
  newInput.type = 'file';
  newInput.accept = 'image/*';
  newInput.className = 'upload-input';
  newInput.onchange = () => previewExtraImage(newInput);
  input.replaceWith(newInput);
}
