document.querySelectorAll('.question-card').forEach(card => {
    const input = card.querySelector('.answer-input');
    const buttons = card.querySelectorAll('.btn-outline-answer');

    buttons.forEach(btn => {
      btn.addEventListener('click', () => {
        btn.classList.toggle('active');
        const selected = [...buttons]
          .filter(b => b.classList.contains('active'))
          .map(b => b.textContent.trim());
        input.value = selected.join('، ');
      });
    });
  });