document.addEventListener("DOMContentLoaded", function () {
    const avatarInput = document.getElementById("avatarInput");
    const avatarZone = document.getElementById("avatarZone");
    const avatarText = avatarZone.querySelector(".avatar-text");
    const avatarPreview = document.getElementById("avatarPreview");
    const removeAvatar = document.getElementById("removeAvatar");
  
    avatarInput.addEventListener("change", function () {
      const file = this.files[0];
      if (!file) return;
  
      const reader = new FileReader();
      reader.onload = function (e) {
        avatarPreview.src = e.target.result;
        avatarPreview.classList.remove("d-none");
        avatarText.classList.add("d-none");
        avatarZone.classList.add("has-image");
        removeAvatar.classList.remove("d-none");
      };
      reader.readAsDataURL(file);
    });
  
    removeAvatar.addEventListener("click", function () {
      avatarInput.value = "";
      avatarPreview.src = "";
      avatarPreview.classList.add("d-none");
      avatarText.classList.remove("d-none");
      avatarZone.classList.remove("has-image");
      removeAvatar.classList.add("d-none");
    });
  });
  

