(() => {
    const $ = sel => document.querySelector(sel);
    const sidebar = $('#sidebar');
    const mobileBtn = $('#mobileMenuBtn');
    const sidebarToggle = $('#sidebarToggle');
    if (mobileBtn && sidebar) {
      mobileBtn.addEventListener('click', () => {
        sidebar.classList.remove('collapsed');
  
        const stBtn = $('#sidebarToggle');
        if (stBtn && stBtn.classList.contains('icon-only')) {
          stBtn.classList.remove('icon-only');
          stBtn.setAttribute('aria-pressed', 'false');
        }
  
        const isOpen = sidebar.classList.toggle('open-mobile');
        mobileBtn.setAttribute('aria-expanded', isOpen ? 'true' : 'false');
      });
    }
  
    if (sidebarToggle && sidebar) {
      sidebarToggle.addEventListener('click', () => {
  
        const isCollapsed = sidebar.classList.toggle('collapsed');
  
        sidebarToggle.setAttribute('aria-pressed', isCollapsed ? 'true' : 'false');
  
        if (isCollapsed) {
          sidebarToggle.classList.add('icon-only');
          const ic = sidebarToggle.querySelector('i');
          if (ic) ic.className = 'bi bi-chevron-left';
        } else {
  
          sidebarToggle.classList.remove('icon-only');
          const ic = sidebarToggle.querySelector('i');
          if (ic) ic.className = 'bi bi-chevron-left';
        }
        if (sidebar.classList.contains('open-mobile')) {
          sidebar.classList.remove('open-mobile');
          if (mobileBtn) mobileBtn.setAttribute('aria-expanded', 'false');
        }
      });
    }
  
    document.addEventListener('click', (e) => {
      if (window.innerWidth < 992 && sidebar.classList.contains('open-mobile')) {
        const inside = sidebar.contains(e.target) || (mobileBtn && mobileBtn.contains(e.target));
        if (!inside) {
          sidebar.classList.remove('open-mobile');
          if (mobileBtn) mobileBtn.setAttribute('aria-expanded', 'false');
        }
      }
    });
  })();
  

/*card-upload*/
  function previewImage(input) {
    const file = input.files[0];
    if (!file) return;
  
    const reader = new FileReader();
    reader.onload = function (e) {
      document.querySelector(".preview-img").src = e.target.result;
      document.querySelector(".preview-img").classList.remove("d-none");
  
      document.querySelector(".upload-placeholder").style.display = "none";
      document.querySelector(".btn-remove").classList.remove("d-none");
    };
    reader.readAsDataURL(file);
  }

  function removeImage() {
    document.querySelector(".preview-img").src = "";
    document.querySelector(".preview-img").classList.add("d-none");
  
    document.querySelector(".upload-placeholder").style.display = "block";
    document.querySelector("#front-upload").value = "";
    document.querySelector(".btn-remove").classList.add("d-none");
  }
  


  /*--wallet--*/
  const amount = document.getElementById("walletAmount");

  document.querySelector(".amount-btn.plus").onclick = () => {
    amount.value = Number(amount.value) + 10000;
  };

  document.querySelector(".amount-btn.minus").onclick = () => {
    if (amount.value > 10000) {
      amount.value = Number(amount.value) - 10000;
    }
  };




document.addEventListener('DOMContentLoaded', function () {
  const modal = document.getElementById('walletModal');
  if (modal && modal.parentElement !== document.body) {
    document.body.appendChild(modal); 
  }
});