(() => {
    const $ = sel => document.querySelector(sel);
    const sidebar = $('#sidebar');
    const mobileBtn = $('#mobileMenuBtn');
    const sidebarToggle = $('#sidebarToggle');
    if (mobileBtn && sidebar) {
      mobileBtn.addEventListener('click', () => {
        sidebar.classList.remove('collapsed');
  
        const stBtn = $('#sidebarToggle');
        if (stBtn && stBtn.classList.contains('icon-only')) {
          stBtn.classList.remove('icon-only');
          stBtn.setAttribute('aria-pressed', 'false');
        }
  
        const isOpen = sidebar.classList.toggle('open-mobile');
        mobileBtn.setAttribute('aria-expanded', isOpen ? 'true' : 'false');
      });
    }
  
    if (sidebarToggle && sidebar) {
      sidebarToggle.addEventListener('click', () => {
  
        const isCollapsed = sidebar.classList.toggle('collapsed');
  
        sidebarToggle.setAttribute('aria-pressed', isCollapsed ? 'true' : 'false');
  
        if (isCollapsed) {
          sidebarToggle.classList.add('icon-only');
          const ic = sidebarToggle.querySelector('i');
          if (ic) ic.className = 'bi bi-chevron-left';
        } else {
  
          sidebarToggle.classList.remove('icon-only');
          const ic = sidebarToggle.querySelector('i');
          if (ic) ic.className = 'bi bi-chevron-left';
        }
        if (sidebar.classList.contains('open-mobile')) {
          sidebar.classList.remove('open-mobile');
          if (mobileBtn) mobileBtn.setAttribute('aria-expanded', 'false');
        }
      });
    }
  
    document.addEventListener('click', (e) => {
      if (window.innerWidth < 992 && sidebar.classList.contains('open-mobile')) {
        const inside = sidebar.contains(e.target) || (mobileBtn && mobileBtn.contains(e.target));
        if (!inside) {
          sidebar.classList.remove('open-mobile');
          if (mobileBtn) mobileBtn.setAttribute('aria-expanded', 'false');
        }
      }
    });
  })();
  


    /*--wallet--*/
    const amount = document.getElementById("walletAmount");

    document.querySelector(".amount-btn.plus").onclick = () => {
      amount.value = Number(amount.value) + 10000;
    };
  
    document.querySelector(".amount-btn.minus").onclick = () => {
      if (amount.value > 10000) {
        amount.value = Number(amount.value) - 10000;
      }
    };
  
  
  
  
  document.addEventListener('DOMContentLoaded', function () {
    const modal = document.getElementById('walletModal');
    if (modal && modal.parentElement !== document.body) {
      document.body.appendChild(modal); 
    }
  });